<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TTskill - Register</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>

    <div class="container mt-4">
        <!-- header -->
        <?php include 'header.php'; ?>

        <form id="application-form" action="process.php" method="POST" enctype="multipart/form-data">
            
            <!-- Personal Information -->
            <div class="form-group row">
                <label for="fullName" class="col-sm-2 col-form-label">Full Name:</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="fullName" name="fullName" required>
                </div>
            </div>
            <div class="form-group row">
                <label for="emailAddress" class="col-sm-2 col-form-label">Email Address:</label>
                <div class="col-sm-10">
                    <input type="email" class="form-control" id="emailAddress" name="emailAddress" required>
                </div>
            </div>
            <div class="form-group row">
                <label for="contactNumber" class="col-sm-2 col-form-label">Contact Number:</label>
                <div class="col-sm-10">
                    <input type="tel" class="form-control" id="contactNumber" name="contactNumber" required>
                </div>
            </div>
            <div class="form-group row">
                <label for="dob" class="col-sm-2 col-form-label">Date of Birth:</label>
                <div class="col-sm-10">
                    <input type="date" class="form-control" id="dob" name="dob" required>
                </div>
            </div>

            <!-- Academic Details -->
            <div class="form-group row">
                <label for="universityName" class="col-sm-2 col-form-label">University/College Name:</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="universityName" name="universityName" required>
                </div>
            </div>
            <div class="form-group row">
                <label for="degreeProgram" class="col-sm-2 col-form-label">Degree Program:</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="degreeProgram" name="degreeProgram" required>
                </div>
            </div>
            <div class="form-group row">
                <label for="yearOfStudy" class="col-sm-2 col-form-label">Year of Study:</label>
                <div class="col-sm-10">
                    <select class="form-control" id="yearOfStudy" name="yearOfStudy" required>
                        <option value="1st Year">1st Year</option>
                        <option value="2nd Year">2nd Year</option>
                        <option value="3rd Year">3rd Year</option>
                        <option value="4th Year">4th Year</option>
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <label for="department" class="col-sm-2 col-form-label">Department/Major:</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="department" name="department" required>
                </div>
            </div>

            <!-- Primary Skills -->
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">Primary Skills:</label>
                <div class="col-sm-10">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="skills[]" id="programming" value="Programming">
                        <label class="form-check-label" for="programming">Programming</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="skills[]" id="dataAnalysis" value="Data Analysis">
                        <label class="form-check-label" for="dataAnalysis">Data Analysis</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="skills[]" id="projectManagement" value="Project Management">
                        <label class="form-check-label" for="projectManagement">Project Management</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="skills[]" id="problemSolving" value="Problem Solving">
                        <label class="form-check-label" for="problemSolving">Problem Solving</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="skills[]" id="designThinking" value="Design Thinking">
                        <label class="form-check-label" for="designThinking">Design Thinking</label>
                    </div>
                </div>
            </div>

            <!-- Areas of Interest in Logistics and Supply Chain -->
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">Areas of Interest in Logistics and Supply Chain:</label>
                <div class="col-sm-10">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="interests[]" id="supplyChainOptimization" value="Supply Chain Optimization">
                        <label class="form-check-label" for="supplyChainOptimization">Supply Chain Optimization</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="interests[]" id="logisticsManagement" value="Logistics Management">
                        <label class="form-check-label" for="logisticsManagement">Logistics Management</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="interests[]" id="inventoryManagement" value="Inventory Management">
                        <label class="form-check-label" for="inventoryManagement">Inventory Management</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="interests[]" id="automation" value="Automation">
                        <label class="form-check-label" for="automation">Automation</label>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label for="projectidea" class="col-sm-2 col-form-label">Briefly describe your Idea in one sentence:</label>
                <div class="col-sm-10">
                    <textarea class="form-control" id="projectidea" name="projectidea" rows="3" placeholder="Eg. I propose (solution) to solve (the problem) which is better than (competitors or existing solutions) because(unique value)"></textarea>
                </div>
            </div>

            <!-- Previous Experience -->
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">Have you participated in hackathons before?</label>
                <div class="col-sm-10">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="hackathonExperience" id="hackathonYes" value="Yes" required>
                        <label class="form-check-label" for="hackathonYes">Yes</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="hackathonExperience" id="hackathonNo" value="No" required>
                        <label class="form-check-label" for="hackathonNo">No</label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label for="projectExperience" class="col-sm-2 col-form-label">Briefly describe any relevant projects or experiences:</label>
                <div class="col-sm-10">
                    <textarea class="form-control" id="projectExperience" name="projectExperience" rows="3"></textarea>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="form-group row">
                <label for="participationReason" class="col-sm-2 col-form-label">Why do you want to participate in the LogistiX Innovation Challenge?</label>
                <div class="col-sm-10">
                    <textarea class="form-control" id="participationReason" name="participationReason" rows="3" required></textarea>
                </div>
            </div>
            <div class="form-group row">
                <label for="howDidYouHear" class="col-sm-2 col-form-label">How did you hear about this event?</label>
                <div class="col-sm-10">
                    <select class="form-control" id="howDidYouHear" name="howDidYouHear" required>
                        <option value="Social Media">Social Media</option>
                        <option value="College">College</option>
                        <option value="Friends">Friends</option>
                        <option value="Website">Website</option>
                        <option value="Email">Email</option>
                    </select>
                </div>
            </div>

            <!-- Consent Checkbox -->
            <div class="form-group row">
                <div class="col-sm-10 offset-sm-2">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="consentCheckbox" name="consentCheckbox" required>
                        <label class="form-check-label" for="consentCheckbox">
                            I agree to the terms and conditions of the LogistiX Innovation Challenge and consent to my data being used for event-related communications.
                        </label>
                    </div>
                </div>
            </div>

            <!-- Submit and Preview Buttons -->
            <div class="form-group row">
                <div class="col-sm-10 offset-sm-2">
                    
                    <button type="submit" class="btn btn-primary">Submit Application</button>
                </div>
            </div>
        </form>
        <!-- Footer -->
    <?php include 'footer.php'; ?>
    </div>

    

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        function previewForm() {
            // Add your preview functionality here
            alert('This is a preview of your application.');
        }
    </script>
</body>
</html>
