<?php
session_start();

// Check if the user is logged in, if not redirect to login page
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

require_once 'db.php';

$registerNumber = "";
$data = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $registerNumber = $_POST['register_number'];

    // Query to fetch the details based on register number
    $query = "
    SELECT 
    a.register_number, a.name, a.degree, a.class_department, a.stream, 
    a.address, a.mobile, a.email, a.fathers_name, a.fathers_occupation,
    a.mothers_name, a.mothers_occupation, a.guardian_name, a.guardian_occupation, 
    a.annual_income, a.contact_number, a.reason, a.photo, a.created_at,
    s.sibling_name, s.sibling_status, s.sibling_employment
    FROM 
    manna_scheme_applications a
    LEFT JOIN 
    manna_scheme_siblings s ON a.id = s.application_id
    WHERE a.register_number = ?
    ";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $registerNumber);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>Search Application - Manna Scheme</title>
        <link href="css/styles.css" rel="stylesheet" />
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
        <style>
            .modal-content {
                border-radius: 10px;
                padding: 20px;
            }
            .form-group {
                margin-bottom: 20px;
            }
            .form-control {
                border-radius: 5px;
                padding: 10px;
            }
            .btn-primary {
                background-color: #78091e;
                border-color: #78091e;
                border-radius: 5px;
            }
            .btn-primary:hover {
                background-color: #5c0717;
                border-color: #5c0717;
            }
            .modal-body img {
                display: block;
                margin: 0 auto;
                max-width: 100%;
                height: auto;
                border-radius: 10px;
            }
            .modal-body p {
                margin-bottom: 10px;
            }
            .modal-body h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
        </style>
    </head>
    <body class="sb-nav-fixed">
        <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
            <!-- Navbar Brand-->
            <a class="navbar-brand ps-3" href="index.html">Manna Scheme</a>
            <!-- Sidebar Toggle-->
            <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
            <!-- Navbar-->
            <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="#!">Settings</a></li>
                        <li><a class="dropdown-item" href="#!">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
        <div id="layoutSidenav">
            <div id="layoutSidenav_nav">
                <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                    <div class="sb-sidenav-menu">
                        <div class="nav">
                            <a class="nav-link" href="index.html">
                                <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                                Dashboard
                            </a>
                            <!-- Additional Links -->
                        </div>
                    </div>
                    <div class="sb-sidenav-footer">
                        <div class="small">Logged in as:</div>
                        Admin
                    </div>
                </nav>
            </div>
            <div id="layoutSidenav_content">
                <main>
                    <div class="container mt-5">
                        <h1 class="mb-4">Search Application by Register Number</h1>
                        <form method="post" id="searchForm">
                            <div class="form-group">
                                <label for="register_number">Enter Register Number:</label>
                                <input type="text" class="form-control" id="register_number" name="register_number" value="<?php echo htmlspecialchars($registerNumber); ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Search</button>
                        </form>

                        <!-- Modal -->
                        <div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="detailsModalLabel">Application Details</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?php if ($data): ?>
                                            <p><strong>Register Number:</strong> <?php echo htmlspecialchars($data['register_number']); ?></p>
                                            <p><strong>Name:</strong> <?php echo htmlspecialchars($data['name']); ?></p>
                                            <p><strong>Degree:</strong> <?php echo htmlspecialchars($data['degree']); ?></p>
                                            <p><strong>Class & Department:</strong> <?php echo htmlspecialchars($data['class_department']); ?></p>
                                            <p><strong>Stream:</strong> <?php echo htmlspecialchars($data['stream']); ?></p>
                                            <p><strong>Address:</strong> <?php echo htmlspecialchars($data['address']); ?></p>
                                            <p><strong>Mobile:</strong> <?php echo htmlspecialchars($data['mobile']); ?></p>
                                            <p><strong>Email:</strong> <?php echo htmlspecialchars($data['email']); ?></p>
                                            <p><strong>Father's Name:</strong> <?php echo htmlspecialchars($data['fathers_name']); ?></p>
                                            <p><strong>Father's Occupation:</strong> <?php echo htmlspecialchars($data['fathers_occupation']); ?></p>
                                            <p><strong>Mother's Name:</strong> <?php echo htmlspecialchars($data['mothers_name']); ?></p>
                                            <p><strong>Mother's Occupation:</strong> <?php echo htmlspecialchars($data['mothers_occupation']); ?></p>
                                            <p><strong>Guardian's Name:</strong> <?php echo htmlspecialchars($data['guardian_name']); ?></p>
                                            <p><strong>Guardian's Occupation:</strong> <?php echo htmlspecialchars($data['guardian_occupation']); ?></p>
                                            <p><strong>Annual Income:</strong> <?php echo htmlspecialchars($data['annual_income']); ?></p>
                                            <p><strong>Contact Number:</strong> <?php echo htmlspecialchars($data['contact_number']); ?></p>
                                            <p><strong>Reason:</strong> <?php echo htmlspecialchars($data['reason']); ?></p>
                                            <p><strong>Photo:</strong> <img src="<?php echo htmlspecialchars($data['photo']); ?>" alt="Photo" width="150"></p>
                                            <p><strong>Created At:</strong> <?php echo htmlspecialchars($data['created_at']); ?></p>
                                            <h3 class="mt-4">Sibling Details</h3>
                                            <p><strong>Sibling Name:</strong> <?php echo htmlspecialchars($data['sibling_name']); ?></p>
                                            <p><strong>Sibling Status:</strong> <?php echo htmlspecialchars($data['sibling_status']); ?></p>
                                            <p><strong>Sibling Employment:</strong> <?php echo htmlspecialchars($data['sibling_employment']); ?></p>
                                        <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST"): ?>
                                            <p class="mt-5">No data found for the entered register number.</p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <footer class="py-4 bg-light mt-auto">
                    <div class="container-fluid px-4">
                        <div class="d-flex align-items-center justify-content-between small">
                            <div class="text-muted">&copy; Your Website 2024</div>
                            <div>
                                <a href="#">Privacy Policy</a>
                                &middot;
                                <a href="#">Terms &amp; Conditions</a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script>
            document.getElementById('searchForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent form submission
                const data = <?php echo json_encode($data); ?>;
                if (data) {
                    const modal = new bootstrap.Modal(document.getElementById('detailsModal'));
                    modal.show();
                }
            });
        </script>
    </body>
</html>
