<?php
// Check if the user is logged in by checking the cookie
if (!isset($_COOKIE['loggedin']) || $_COOKIE['loggedin'] !== 'true') {
    // If the cookie is not set or is not valid, redirect to the login page
    header("Location: login.php");
    exit;
}

require_once 'db.php';

// Fetch the counts
$idCountQuery = "SELECT COUNT(DISTINCT email) AS id_count FROM applications";
$hackathonYesCountQuery = "SELECT COUNT(*) AS hackathon_yes_count FROM applications WHERE hackathon_experience = 'Yes'";
$projectCountQuery = "SELECT COUNT(*) AS project_count FROM applications WHERE project_experience IS NOT NULL";
$resumeCountQuery = "SELECT COUNT(*) AS resume_count FROM applications WHERE resume IS NOT NULL";

// Execute the queries
$idCountResult = $conn->query($idCountQuery);
$hackathonYesCountResult = $conn->query($hackathonYesCountQuery);
$projectCountResult = $conn->query($projectCountQuery);
$resumeCountResult = $conn->query($resumeCountQuery);

// Fetch the results
$idCount = $idCountResult->fetch_assoc()['id_count'];
$hackathonYesCount = $hackathonYesCountResult->fetch_assoc()['hackathon_yes_count'];
$projectCount = $projectCountResult->fetch_assoc()['project_count'];
$resumeCount = $resumeCountResult->fetch_assoc()['resume_count'];

// Query to fetch data for the table
$dataQuery = "SELECT * FROM applications";
$result = $conn->query($dataQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>TTSkill-Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.min.css" rel="stylesheet" />
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="sb-nav-fixed">
    <?php require_once 'topbar.html' ?>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading">Menu</div>
                        <a class="nav-link" href="dashboard.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Dashboard
                        </a>
                        <a class="nav-link" href="search.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-chart-area"></i></div>
                            Search
                        </a>
                        <a class="nav-link" href="tables.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-table"></i></div>
                            Database
                        </a>                         
                    </div>
                </div>
                <div class="sb-sidenav-footer">
                    <div class="small">Logged in as:</div>
                    TTSkill
                </div>
            </nav>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4">
                    <h1 class="mt-4">Dashboard</h1>
                    <ol class="breadcrumb mb-4">
                        <li class="breadcrumb-item active">TTSKill DB 2024-2025</li>
                    </ol>
                    <div class="row">
                        <div class="col-xl-3 col-md-6">
                            <div class="card bg-primary text-white mb-4">
                                <div class="card-body">ID Count: <?php echo $idCount; ?></div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="#"></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card bg-success text-white mb-4">
                                <div class="card-body">Hackathon Experience (Yes): <?php echo $hackathonYesCount; ?></div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="#"></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card bg-warning text-white mb-4">
                                <div class="card-body">Project Experience Count: <?php echo $projectCount; ?></div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="#"></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card bg-info text-white mb-4">
                                <div class="card-body">Resume Count: <?php echo $resumeCount; ?></div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="#"></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Application Data Table -->
                    <div class="card mb-4">
                            <div class="card-header">
                                <i class="fas fa-table me-1"></i>
                                Applications
                            </div>
                            <div class="card-body">
                                <?php if ($result === false) : ?>
                                    <p>Error: <?= $conn->error ?></p>
                                <?php elseif ($result->num_rows > 0) : ?>
                                    <table id="datatablesSimple">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Full Name</th>
                                                <th>Email</th>
                                                <th>Contact Number</th>
                                                <th>Date of Birth</th>
                                                <th>University Name</th>
                                                <th>Degree Program</th>
                                                <th>Year of Study</th>
                                                <th>Department</th>
                                                <th>Skills</th>
                                                <th>Interests</th>
                                                <th>Project Idea</th>
                                                <th>Hackathon Experience</th>
                                                <th>Project Experience</th>
                                                <th>Participation Reason</th>
                                                <th>How Did You Hear</th>
                                                <th>Resume</th>
                                                <th>Created At</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                <th>ID</th>
                                                <th>Full Name</th>
                                                <th>Email</th>
                                                <th>Contact Number</th>
                                                <th>Date of Birth</th>
                                                <th>University Name</th>
                                                <th>Degree Program</th>
                                                <th>Year of Study</th>
                                                <th>Department</th>
                                                <th>Skills</th>
                                                <th>Interests</th>
                                                <th>Project Idea</th>
                                                <th>Hackathon Experience</th>
                                                <th>Project Experience</th>
                                                <th>Participation Reason</th>
                                                <th>How Did You Hear</th>
                                                <th>Resume</th>
                                                <th>Created At</th>                                                
                                            </tr>
                                        </tfoot>
                                        <tbody>
                                            <?php while ($row = $result->fetch_assoc()) : ?>
                                                <tr>
                                                    <td><?= htmlspecialchars($row['id']) ?></td>
                                                    <td><?= htmlspecialchars($row['full_name']) ?></td>
                                                    <td><?= htmlspecialchars($row['email']) ?></td>
                                                    <td><?= htmlspecialchars($row['contact_number']) ?></td>
                                                    <td><?= htmlspecialchars($row['dob']) ?></td>
                                                    <td><?= htmlspecialchars($row['university_name']) ?></td>
                                                    <td><?= htmlspecialchars($row['degree_program']) ?></td>
                                                    <td><?= htmlspecialchars($row['year_of_study']) ?></td>
                                                    <td><?= htmlspecialchars($row['department']) ?></td>
                                                    <td><?= htmlspecialchars($row['skills']) ?></td>
                                                    <td><?= htmlspecialchars($row['interests']) ?></td>
                                                    <td><?= htmlspecialchars($row['projectidea']) ?></td>
                                                    <td><?= htmlspecialchars($row['hackathon_experience']) ?></td>
                                                    <td><?= htmlspecialchars($row['project_experience']) ?></td>
                                                    <td><?= htmlspecialchars($row['participation_reason']) ?></td>
                                                    <td><?= htmlspecialchars($row['how_did_you_hear']) ?></td>
                                                    <td><a href="uploads/<?= htmlspecialchars($row['resume']) ?>" target="_blank"><?= htmlspecialchars($row['resume']) ?></a></td>
                                                    <td><?= htmlspecialchars($row['created_at']) ?></td>
                                                </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                <?php else : ?>
                                    <p>No applications found.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid px-4">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; Madras Christian College 2024</div>
                        <div>
                            <a href="#">Privacy Policy</a>
                            &middot;
                            <a href="#">Terms & Conditions</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"></script>
    <script src="js/datatables-simple-demo.js"></script>
</body>
</html>
