<?php
// Include database connection file
require_once 'db.php';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve form data
    $fullName = $_POST['fullName'];
    $email = $_POST['emailAddress'];
    $contactNumber = $_POST['contactNumber'];
    $dob = $_POST['dob'];
    $universityName = $_POST['universityName'];
    $degreeProgram = $_POST['degreeProgram'];
    $yearOfStudy = $_POST['yearOfStudy'];
    $department = $_POST['department'];
    $projectidea = $_POST['projectidea'];

    // Retrieve primary skills
    $skills = isset($_POST['skills']) ? implode(', ', $_POST['skills']) : '';

    // Retrieve areas of interest
    $interests = isset($_POST['interests']) ? implode(', ', $_POST['interests']) : '';

    // Retrieve hackathon experience
    $hackathonExperience = $_POST['hackathonExperience'];

    // Retrieve project experience
    $projectExperience = $_POST['projectExperience'];

    // Retrieve participation reason
    $participationReason = $_POST['participationReason'];

    // Retrieve how did you hear
    $howDidYouHear = $_POST['howDidYouHear'];

    // Handle file upload
    $resume = $_FILES['resume'];
    $resumeName = time() . "_" . basename($resume['name']);
    $uploadDir = "uploads/";
    $uploadFile = $uploadDir . $resumeName;

    if (!move_uploaded_file($resume['tmp_name'], $uploadFile)) {
        echo "<script>
                alert('Failed to upload resume.');
                window.history.back();
              </script>";
        exit;
    }

    // Check if the email already exists
    $checkSql = "SELECT id FROM applications WHERE email = ?";
    $stmtCheck = $conn->prepare($checkSql);
    $stmtCheck->bind_param("s", $email);
    $stmtCheck->execute();
    $stmtCheck->store_result();

    if ($stmtCheck->num_rows > 0) {
        echo "<script>
                alert('The Email ID already exists.');
                window.history.back();
              </script>";
        exit;
    }
    $stmtCheck->close();

    // Insert form data into the database
    $sql = "INSERT INTO applications 
            (full_name, email, contact_number, dob, university_name, degree_program, year_of_study, department, 
             skills, interests, hackathon_experience, project_experience, participation_reason, how_did_you_hear, resume, projectidea) 
            VALUES 
            (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssssssssss", $fullName, $email, $contactNumber, $dob, $universityName, $degreeProgram, 
                      $yearOfStudy, $department, $skills, $interests, $hackathonExperience, $projectExperience, 
                      $participationReason, $howDidYouHear, $resumeName, $projectidea);

    if ($stmt->execute()) {
        // Redirect to a thank you page
        header("Location: thank_you.html");
        exit;
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
